# starsim_start.py
# David Handy  08 February 2005
"""
Start up the StarSim game.

The intended use for this program is for it to be compiled into a "stub"
Python interpreter for Windows via py2exe. The stub should be run in a
a directory containing your main module, the files produced by py2exe, and a
Python distribution. The purpose is to distribute your program with a
minimal starter .exe file.

The main module is imported using __import__ to deliberately fool py2exe so
that it does not pack all of the python code into library.zip. We are trying
for a minimal library.zip that will serve several starter stubs, leaving
all of the program's source code in external .py files.
"""

import os
import sys

MAIN_MODULE_NAME = 'starsim_control' # modify this line for your program


def main():
    print __doc__
    print
    print "This is the main() method in the runmain module itself. If you"
    print "see this message then the self-test passed."
    print 
    print "sys.argv =", sys.argv
    print "sys.path =", sys.path


def runmain():
    """Import the "main" module and run its main() function."""
    dir_name = os.path.dirname(sys.argv[0])
    dir_name = os.path.abspath(dir_name)
    # Assume that this is a py2exe-produced executable, set up path
    sys.path[0:0] = [
        dir_name,
        os.path.join(dir_name, 'DLLs'),
        os.path.join(dir_name, 'lib'),
        os.path.join(dir_name, 'lib', 'lib-tk'),
        os.path.join(dir_name, 'lib', 'site-packages'),
        ]
    main_module = __import__(MAIN_MODULE_NAME)
    return main_module.main()


if __name__ == '__main__':
    sys.exit(runmain())

# end-of-file
