# starsim_player.py
# David Handy  11 June 2004
"""
StarSim game
Connects to a starsim server, animates spaceships.

Use:

    python starsim_player.py host port user

"""

import os
import sys

from starsim.player.playermod import Player

module = sys.modules[__name__]
script_file = getattr(module, '__file__', sys.argv[0])
script_dir = os.path.dirname(script_file)

help_url = os.path.join(script_dir, 'starsim.html')
help_url = os.path.normpath(help_url)
help_url = os.path.normcase(help_url)
help_url = os.path.abspath(help_url)
help_url= 'file://' + help_url


def main():
    if len(sys.argv) < 3:
        print __doc__
        return
    host = sys.argv[1]
    try:
        port = int(sys.argv[2])
    except ValueError:
        port = sys.argv[2] # this may cause an error later
    pw = Player((host, port), help_url=help_url)
    pw.run()


if __name__ == '__main__':
    main()

# end-of-file
