# starsim/util.py
"""
StarSim utility module

Utility functions, etc. used by multiple modules.
"""

import re
import sys
import time


# Use the most precise time function depending on the platform

if sys.platform.startswith('win'):
    def gettime():
        return time.clock()
else:
    def gettime():
        return time.time()


_num_pattern = r"(?:[+-]?(?:\d+\.\d+)|(?:\d+\.)|(?:\.\d+)|(?:\d+))"
_loc_pattern = r"\(?\s*(%(num)s)\s*,\s*(%(num)s)\s*\)?" % {'num': _num_pattern}
_loc_p = re.compile(_loc_pattern)

def parseNumberPair(loc_str):
    m = _loc_p.match(loc_str)
    if not m:
        raise ValueError("Number pair is not in the proper (x, y) format")
    try:
        x_str, y_str = m.groups()
        return (float(x_str), float(y_str))
    except ValueError:
        raise ValueError("Number pair is not in the proper (x, y) format")


# end-of-file
