# starsim/scenarios/missionofmercy.py
"""
"Mission of Mercy" StarSim scenario module

Creates the starships using the default universe creator, and then creates
a bunch of random stars, and more.
"""

import random

from starsim import debug
from starsim.server import universedb, model
from starsim.const import SCAN_LIMIT


def create():
    u = universedb.createDefaultUniverse()
    # create stars
    size = SCAN_LIMIT * 20.0
    for i in xrange(1000):
        x = (random.random() * size) - (size/2)
        y = (random.random() * size) - (size/2)
        model.Star(u, (x, y))
    # create Fuon invaders
    for i in xrange(10):
        x = (random.random() * size) - (size/2)
        y = (random.random() * size) - (size/2)
        model.FuonInvader(u, (x, y), color='red')
    # create Fuon base
    model.FuonBase(u, (1.5, 1.5), color='violet', name='$#*%#')
    # create starbase
    base = model.StarBase(u, (-0.7, -0.5), color='wheat', name='Archon')
    # crisis on the starbase
    base.addNeed('food', 110, "We're starving due to famine")
    base.addCargo('fuel', 85)
    # EarthBase can help
    earth_base = u.home_base
    earth_base.addCargo('food', 220)
    return u


# end-of-file
