# starsim/scenarios/__init__.py
"""
StarSim scenarios package

This package contains modules for starting new games. Each module has a
create() function, called without parameters, that returns a new
starsim.universedb.Universe object, populated with (hopefully) interesting
contents.
"""

import os
import sys

module = sys.modules[__name__]


def listmodules():
    modules = []
    module_dir = os.path.dirname(module.__file__)
    for name in os.listdir(module_dir):
        if name.endswith('.py') and not name.startswith('__'):
            modules.append(name[:-3])
    return modules


# end-of-file
