# debug.py
# David Handy  18 December 2004
"""
StarSim debug control module
"""

pause_player = False

pause_display = False

print_player_messages = True


def garbage_collect_and_report():
    import gc
    import sys
    print "gc.isenabled() ==", gc.isenabled()
    sys.stdout.flush()
    orig_debug_flags = gc.get_debug()
    gc.set_debug(gc.DEBUG_STATS)
    num_unreachable_objects = gc.collect()
    gc.set_debug(orig_debug_flags)
    print "num_unreachable_objects ==", num_unreachable_objects
    sys.stdout.flush()


def dump(obj):
    """Dump info about an object."""
    try:
        print "%s@%s:" % (obj.__class__.__name__, hex(id(obj)))
        for name in dir(obj):
            if name.startswith('__'):
                continue
            a = getattr(obj, name)
            if callable(a):
                continue
            print "    %s: %s" % (name, repr(a))
    except:
        print >> sys.stderr, '** error dumping', repr(obj)


# end-of-file
