# starsim/__init__.py
# David Handy  October 2004
"""
StarSim game package

All of the real functionality is in the various sub-packages.
"""

import os

import cpif

from starsim.version import __version__


def getUserDir():
    """
    Return the path to the directory where the per-user files are stored.
    """
    homedir = cpif.homedir()
    user_dir = os.path.join(homedir, 'StarSim')
    if not os.path.exists(user_dir):
        os.makedirs(user_dir)
    return user_dir


def getDataDir():
    """
    Return the path to the directory where the StarSim system files for the
    whole computer have been installed.
    """
    return os.path.join(sys.prefix, 'share', 'starsim-' + starsim.__version__)


# end-of-file
