# welcomelib.py
# Copyright (c) 2003-2006 by David Handy
# This script installs the student files
# that come with the book "Computer Programing is Fun!"
"""
Copy the student files to the user's MyPrograms directory.
"""

import os
import sys
import Tkinter
Tk = Tkinter
import tkMessageBox
import glob
try:
    import webbrowser
except ImportError:
    webbrowser = None

# defense against changes between Python 1.5.2 and 2.3
try:
    True
    False
except NameError:
    True = 1
    False = 0
try:
    file
except NameError:
    file = open

from cpif.util import copytext


WELCOME_TEXT = """\
Welcome!

Press Ok to install the CPIF sample programs in your MyPrograms directory,
or Cancel to quit.

Copyright (C) 2003-2006 by David Handy
"""

WEB_SITE_URL = "http://www.handysoftware.com/cpif/"

# Note: The "import cpif" statements are inside method and function
# definitions for a valid reason. This module gets imported from the cpif
# package __init__, so cpif itself is not available at import time.


class WelcomeApp(Tk.Frame):

    def __init__(self, cpif_data_dir):
        self.__cpif_data_dir = cpif_data_dir
        parent = Tk.Tk()
        Tk.Frame.__init__(self, parent)
        self.pack(expand=Tk.YES, fill=Tk.BOTH)
        import cpif
        self.master.title('CPIF Welcome - version ' + cpif.__version__)
        self.master.iconname('CPIF-Welcome')
        Tk.Label(self,
                 text=WELCOME_TEXT,
                 ).pack(side=Tk.TOP, expand=Tk.YES, fill=Tk.BOTH)
        button_frame = Tk.Frame(self)
        Tk.Button(button_frame, text="Ok",
                  command=self.__installStudentFiles).pack(
                      side=Tk.LEFT, expand=Tk.YES, fill=Tk.BOTH)
        Tk.Button(button_frame, text="Cancel",
                  command=self.__quit).pack(
                      side=Tk.LEFT, expand=Tk.YES, fill=Tk.BOTH)
        button_frame.pack(side=Tk.TOP, expand=Tk.YES, fill=Tk.BOTH)
        Tk.Button(self, text = "Go to " + WEB_SITE_URL,
                  command=self.__webSite).pack(
                      side=Tk.LEFT, expand=Tk.YES, fill=Tk.BOTH)
        # graphics is not Python 1.5.2 compatible!
        try:
            import cpif.graphics
            cpif.graphics.centerWindow(parent)
        except:
            pass
        self.result = None

    def mainloop(self):
        self.master.mainloop()
        if self.result is not None:
            self.master.destroy()

    def __installStudentFiles(self):
        try:
            n = installFiles(cpif_data_dir=self.__cpif_data_dir)
            tkMessageBox.showinfo(
                title="Student Files Copied",
                message="%d student files have been copied to\n"
                        "your personal MyPrograms directory" % n)
        except (OSError, IOError):
            exctype, value = sys.exc_info()[:2]
            tkMessageBox.showerror(
                title="Error Installing Files",
                message=("There was a problem installing the files:\n" +
                          str(value)))
        self.result = 'Ok'
        self.master.quit()

    def __quit(self):
        self.result = 'Cancel'
        self.master.quit()

    def __webSite(self):
        if webbrowser:
            webbrowser.open(WEB_SITE_URL)


def installFiles(verbose=True, cpif_data_dir=None):
    """
    Install the student files in the user's MyPrograms directory.
    Return the number of files copied.
    verbose: if true, print the file names as they are copied
    cpif_data_dir: the directory containing the samples subdirectory, etc.
    """
    import cpif
    if not cpif_data_dir:
        cpif_data_dir = cpif.datadir()
    lander_dir = os.path.join(cpif_data_dir, 'lander')
    samples_dir = os.path.join(cpif_data_dir, 'samples')
    my_programs = cpif.myprograms() # creates MyPrograms if necessary
    user_lander_dir = os.path.join(my_programs, 'lander')
    user_samples_dir = os.path.join(my_programs, 'samples')
    n = 0
    for srcdir, destdir in [(lander_dir, user_lander_dir),
                            (samples_dir, user_samples_dir)]:
        if not os.path.isdir(destdir):
            os.mkdir(destdir)
        n += copytext.copyTextFiles(['*.py', '*.txt'], srcdir, destdir, 
                                    verbose=verbose)
    return n


def runwelcome(cpif_data_dir):
    app = WelcomeApp(cpif_data_dir)
    app.mainloop()


if __name__ == '__main__':
    import cpif
    runwelcome(cpif.datadir())

# end-of-file
