# cpif/misc.py
# Copyright (C) 2004 by David Handy
# This is the misc module in the cpif package.
# See http://www.handysoftware.com/cpif/
"""
This module contains miscellaneous functions and classes to help in writing
programs for the quizzes in the book.
"""

import random


def makeMathProblem():
    """
    Create a simple arithmetic problem involving two integers and the basic
    operations +, -, *, and / (plus, minus, times, divide.) The problem is
    chosen such that the answer is never -99.

    Return a tuple consisting of (problem_string, answer_number).
    You can use the problem_string string as a prompt for
    cpif.inputInteger().
    """
    def getOperands():
        a = random.randint(-12, 12)
        b = random.randint(-12, 12)
        # make negative operands less likely
        if a < 0:
            if random.random() < 0.5:
                a = abs(a)
        if b < 0:
            if random.random() < 0.5:
                b = abs(b)
        return a, b
    while True:
        a, b = getOperands()
        operator = random.choice(['+', '-', '*', '/'])
        while b < 0 and operator == '-':
            a, b = getOperands()
        while operator == '/':
            if b == 0:
                a, b = getOperands()
                continue
            if float(a) / b <> a // b:
                a, b = getOperands()
                continue
            if a // b == 0 or abs(a // b) == 1:
                if random.random() < 0.75:
                    a, b = getOperands()
                    continue
            break
        expr = "%d %s %d" % (a, operator, b)
        answer = eval(expr)
        if answer == -99:
            continue
        return ("What is %s ? " % expr, answer)


# end-of-file
