# wordfile.py
# Look up words from and add to a dictionary file.

import csv
import os

words = {}
words_file = 'words.csv'
if not os.path.exists(words_file):
    print "New word database"
else:
    print "Loading word database", words_file
    f = file(words_file, 'rb')
    r = csv.reader(f)
    for word, definition in r:
        words[word] = definition
    f.close()

print "Enter a word to look up, or Enter to quit."
while True:
    word = raw_input("Word: ")
    if not word:
        break
    definition = words.get(word)
    if definition:
        print definition
    else:
        print "I don't know what", word, "means."
        print "Enter a definition, or Enter to skip."
        definition = raw_input("Definition: ")
        if not definition:
            continue
        words[word] = definition

print "Saving word database in", words_file
f = file(words_file, 'wb')
w = csv.writer(f)
for word, definition in words.items():
    w.writerow((word, definition))
f.close()

# end-of-file
