# radii.py
# Draw concentric circles with equal areas inside the bands

from math import pi, sqrt

from cpif.graphics import DrawingWindow

def radii(r, limit):
    if r > limit:
        return
    A = pi * r * r
    yield r
    while True:
        r = sqrt((A/pi) + r*r)
        if r > limit:
            return
        yield r

start = 25
limit = 250
dw = DrawingWindow(limit*2, limit*2)
for r in radii(start, limit):
    dw.circle(limit, limit, r, 'black')
dw.run()

# end-of-file
