# playtones.py
# Generate tones going up and tones going down.
# Mix and play the sounds, waiting for the sound to finish.

from cpif import sound

# make rising tones
tones = []
for freq in range(100, 2100, 100):
    tones.append(sound.gentone(freq, 0.1))
rising_sound = sound.join(tones)

# make falling tones
tones = []
for freq in range(2100, 0, -100):
    tones.append(sound.gentone(freq, 0.1))
falling_sound = sound.join(tones)

# mix them and play the mixed sound
mixed_sound = sound.mix([rising_sound, falling_sound])
mixed_sound.play()
mixed_sound.wait()

# end-of-file
