# ovals.py
# Sample program that lets you click and drag to draw ovals

from cpif.graphics import DrawingWindow

dw = DrawingWindow(350, 350)
dw.drawText(0, 0, "Click and drag the mouse to draw ovals.")

def startOval(mouse_event):
    x1, y1 = mouse_event.x, mouse_event.y
    oval = dw.oval(x1, y1, x1, y1, 'black', fill='green')
    dw.onMouseMoveCall(stretchOval, oval, x1, y1)
    dw.onMouseUpCall(ovalDone)

def stretchOval(mouse_event, oval, x1, y1):
    x2, y2 = mouse_event.x, mouse_event.y
    dw.setCoords(oval, [(x1, y1), (x2, y2)])

def ovalDone(mouse_event):
    dw.onMouseMoveCall(None)
    dw.onMouseUpCall(None)

dw.onMouseDownCall(startOval)
dw.run()

# end-of-file
