# bounceball.py
# Animate a ball, making it "bounce" off the edges of the window

from cpif.graphics import DrawingWindow

interval = 0.02 # interval between updates, in seconds
width, height = 200, 200 # size of window

class MovingBall:

    def __init__(self):
        # starting position of ball
        self.x = 100
        self.y = 100
        # starting velocity of ball
        self.vx = 1.4
        self.vy = -0.8
        # draw the ball and save its ID
        self.ball = dw.circle(self.x, self.y, 10, 'black', fill='red')

    def moveBall(self):
        dw.moveBy(self.ball, self.vx, self.vy)
        self.x = self.x + self.vx
        self.y = self.y + self.vy
        if self.x < 0 or self.x >= width:
            self.vx = -self.vx
        if self.y < 0 or self.y >= height:
            self.vy = -self.vy

dw = DrawingWindow(width, height)
mb = MovingBall()
dw.onTimerCall(interval, mb.moveBall)
dw.run()

# end-of-file
