# lander2.py
# David Handy  June 2004
"""
Classic Lunar-lander style game.

Use the arrow keys to fire the rockets, Esc to quite the game.
"""

from cpif.graphics import DrawingWindow


class SpaceShip:
    
    def __init__(self, startx, starty):
        self.x = startx
        self.y = starty
        self.vx = 0.0
        self.vy = 0.0
        self.id = self.drawShip(self.x, self.y)

    def keyCallback(self, event):
        if event.keysym == 'Escape':
            dw.close()

    def drawShip(self, x, y):
        size = 20
        p1 = (x,          y - size)
        p2 = (x + size/2, y + size)
        p3 = (x,          y + size/2)
        p4 = (x - size/2, y + size)
        id = dw.polygon([p1, p2, p3, p4], 'black', fill='blue')
        return id

    def update(self):
        self.x = self.x + self.vx
        self.y = self.y + self.vy
        dw.moveBy(self.id, self.vx, self.vy)
        self.vy = self.vy + 0.07


width, height = 640, 480
dw = DrawingWindow(width, height)
ship = SpaceShip(width/2, height/2)
dw.onKeyDownCall(ship.keyCallback)
dw.onTimerCall(0.05, ship.update)
dw.run()

# end-of-file
