# testsound.py
# Copyright (C) 2004 by David Handy
# Test the sound module from the cpif package
# http://www.handysoftware.com/cpif/

import doctest
import sys

from cpif.sound import gentone, gentones, gensilence, mul, join, mix, play


use_pygame = False
if use_pygame:
    print "Using pygame.mixer instead of cpif.sound, for comparison"
    del play
    import time
    import pygame
    import pygame.mixer
    class ChannelWaiter:
        def __init__(self, channel):
            self.__channel = channel
        def wait(self):
            while self.__channel.get_busy():
                time.sleep(0.1)
    def play(soundobj):
        soundobj.getwavef().seek(0)
        s = pygame.mixer.Sound(soundobj.getwavef())
        c = s.play()
        return ChannelWaiter(c)


def risingAndFallingTones():
    tones = []
    for f in xrange(100, 2100, 100):
        t = 20.0 / f
        tones.append((f, t, 0.5))
    for f in xrange(2000, 90, -100):
        t = 20.0 / f
        tones.append((f, t, 0.5))
    soundobj = gentones(tones)
    play(soundobj).wait()


def chord():
    c4 = gentone(261.63, 5.0, 0.5) # C
    e4 = gentone(329.63, 4.0, 0.5) # E
    g4 = gentone(392.00, 3.0, 0.5) # G
    c5 = gentone(261.63 * 2, 2.0, 0.5) # C 8av
    factor = 0.25
    s1 = mul(c4, factor)
    s2 = mul(join([gensilence(1.0), e4]), factor)
    s3 = mul(join([gensilence(2.0), g4]), factor)
    s4 = mul(join([gensilence(3.0), c5]), factor)
    s = mix([s1, s2, s3, s4])
    print >> sys.stderr, "Playing chord ...",
    play(s).wait()
    print >> sys.stderr, "done"


def oppositePhase():
    print >> sys.stderr, "Playing two sounds 180 degrees opposite phase ...",
    p1 = gentone(440.0, 2.0, 0.5, 0.0)
    p2 = gentone(440.0, 2.0, 0.5, 180.0)
    play(mix([p1, p2])).wait()
    print >> sys.stderr, "done"


def main():
    #doctest.testmod(cpif.sound, verbose=True)
    if use_pygame:
        pygame.mixer.init()
    else:
        import cpif.sound
        doctest.testmod(cpif.sound)
    risingAndFallingTones()
    chord()
    oppositePhase()


if __name__ == '__main__':
    main()

# end-of-file
