# Run this script with the version of Python that the person reading the
# book will use. Python 2.4 or higher is required.

# cpif/setup.py
# Created by David Handy  15 August 2003
# Setup for the cpif package (cpif = Computer Programming Is Fun)
# This is the software that accompanies the book:
# Computer Programming Is Fun! by David Handy (c) 2003-2006

# To install the cpif package on your system, run
#   python setup.py install

# Check that we are running the required Python version

import sys

def getVersionTuple(ver):
    """
    Converts a version string into a tuple of integers.

    Examples:
        >>> getVersionTuple('2.3.3 (#3, Dec 31 2003, 15:56:46) ...')
        (2, 3, 3)
        >>> getVersionTuple('2.4a1')
        (2, 4)
    """
    v = []
    s = ''
    ver = ver + ' ' # add sentinel space at end
    for c in ver:
        if c in '0123456789':
            s = s + c
        else:
            if not s:
                break
            try:
                v.append(int(s))
            except ValueError:
                # probably too many digits
                v.append(sys.maxint)
            s = ''
            if c <> '.':
                break
    return tuple(v)

PYTHON_MINIMUM_VERSION = (2, 5)

if PYTHON_MINIMUM_VERSION > getVersionTuple(sys.version):
    raise Exception("Need at least Python version %s.%s for cpif to work." %
                    PYTHON_MINIMUM_VERSION[:2])


# Now that we know we have the right version of Python, import the other
# modules that we need.

import os

from cpif.version import __version__


SCRIPT_DIR = os.path.abspath(os.path.dirname(sys.modules[__name__].__file__))
CPIF_DIR = os.path.join(SCRIPT_DIR, 'cpif')
if not os.path.isdir(CPIF_DIR):
    raise Exception("Cannot find cpif package in setup script directory!")


def main(argv=None):
    if argv is None:
        argv = sys.argv[:]
    print "CPIF = Computer Programming is Fun!"
    print "cpif software setup"
    if len(sys.argv) <= 1:
        print "Run 'python setup.py install' as root for default installation."
        print "Run 'python setup.py --help' for command-line directions."
        print
        return
    from distutils.core import setup
    share_dir = os.path.join('share', 'cpif-' + __version__)
    setup(
        script_args = argv[1:],
        name = "cpif",
        version = __version__,
        description = "Software for the book 'Computer Programming is Fun!'",
        author = "David Handy",
        author_email = "cpif@handysoftware.com",
        url = "http://www.handysoftware.com/cpif/",
        license = "BSD-style",
        platforms = "Windows, Linux",
        scripts = ['cpif-idle.py', 'cpif-welcome.py'],
        packages = ['cpif', 'cpif.data', 'cpif.idlelib', 'cpif.util'],
        package_data = {
            'cpif.data': [
                'images/*.gif',
                'lander/*.py', 'lander/*.txt',
                'samples/*.py', 'samples/*.txt',
                'sounds/*.wav',
                ],
            'cpif.idlelib': [
                '*.def', '*.txt',
                'Icons/*.gif', 'Icons/*.icns',
                ],
            },
        data_files = [
            (share_dir,
                ['AfterInstall.txt', 'LICENSE.txt', 'README-Linux.txt', 
                 'README.txt'])],
        )


if __name__ == '__main__':
    main()

# end-of-file
