# copytext.py
# Copyright (C) 2003 by David Handy - see LICENSE.txt for copying conditions
# Text file conversion utility
"""This module converts text files to the local line-ending style."""

#####################################################################
# KEEP THIS MODULE COMPATIBLE WITH Python 1.5.2 FOR SETUP PURPOSES! #
#####################################################################

import glob
import os
import string

# defense against changes between Python 1.5.2 and 2.3
try:
    True
    False
except NameError:
    True = 1
    False = 0
try:
    file
except NameError:
    file = open


def convertTextFile(src, dst, lineend=os.linesep, verbose=False):
    """Copy the src text file to the desired line-ending convention and write
    it in dst. *Beware* You had better make sure the file is truly a text
    file!"""
    if verbose:
        print "Copying", src, "to", dst
    srcfile = file(src)
    try:
        dstfile = file(dst, 'wb')
        try:
            while True:
                line = srcfile.readline()
                if not line:
                    break
                trimmed_line = string.rstrip(line)
                dstfile.write(trimmed_line)
                dstfile.write(lineend)
        finally:
            dstfile.close()
    finally:
        srcfile.close()


def copyTextFiles(filelist, srcdir, destdir, lineend=os.linesep,
                  verbose=False):
    """Copy all of the text files in filelist found in srcdir to destdir,
    converting the line-endings to the desired convention in the process.
    filelist is a list of file names with no path, globbing permitted.
    Return the number of files copied.
    """
    expanded_filelist = []
    for item in filelist:
        expanded_filelist.extend(glob.glob(os.path.join(srcdir, item)))
    for item in expanded_filelist:
        dstfilename = os.path.join(destdir, os.path.basename(item))
        convertTextFile(item, dstfilename, lineend, verbose=verbose)
    return len(expanded_filelist)


# end-of-file
