# smile.py
# Draw a smiley face

from cpif.graphics import DrawingWindow

size = 400
g = DrawingWindow(size, size, 'white')

# draw "face"
cx, cy = (size/2, size/2)
r = size * 0.35
g.circle(cx, cy, r, 'yellow', fill='yellow')

# draw smile
g.arc(cx, cy, r * 0.5, -45, -90, 'red', style=g.ARC)

# left eye
g.circle(cx - (r * 0.45), cy - (r * 0.45), r * 0.1, 'blue')

# right eye
g.circle(cx + (r * 0.45), cy - (r * 0.45), r * 0.1, 'blue')

# wait for user to close window
g.run()

# end-of-file
