# keymove.py
# Move the box using the arrow keys. Press Esc to exit.

from cpif.graphics import DrawingWindow

dw = DrawingWindow(640, 480)
dw.drawText(0, 0, "Use the arrow keys to move the box, Esc to quit")
box_id = dw.box(310, 230, 330, 250, 'black', fill='light blue')

def keyCallback(event):
    if event.keysym == 'Escape':
        dw.close()
    elif event.keysym == 'Left':
        dw.moveBy(box_id, -20, 0)
    elif event.keysym == 'Right':
        dw.moveBy(box_id, 20, 0)
    elif event.keysym == 'Up':
        dw.moveBy(box_id, 0, -20)
    elif event.keysym == 'Down':
        dw.moveBy(box_id, 0, 20)

dw.onKeyDownCall(keyCallback)
dw.run()

# end-of-file
