# hamurabi.py
# Translated by David Handy  December 2003
# Rule an ancient kingom. Several versions of this game originated in the
# late 1970's. This was translated from the original BASIC version at
# http://www.moorecad.com/classicbasic/basic/general/hamurs.bas

import random


def main():
    print "YOU ARE THE RULER OF THE ANCIENT KINGDOM OF SUMERIA."
    print "YOUR PEOPLE CALL YOU 'HAMURABI THE WISE'. YOUR TASK IS"
    print "TO DEVELOP A STABLE ECONOMY BY THE WISE MANAGEMENT OF"
    print "YOUR RESOURCES. YOU WILL BE BESET FROM TIME TO TIME"
    print "BY NATURAL EVENTS. THE ONLY HELP I CAN GIVE YOU IS THE "
    print "FACT THAT IT TAKES 2 BUSHELS OF GRAIN AS SEED TO PLANT"
    print "AN ACRE. MAY YOU JUDGE WELL, ALKNOWING HAMURABI."
    print "***********HAMURABI IS HERE***********"

    population = 95.
    stored_bushels = 2800.
    harvest = 3000.
    loss_to_rats = harvest-stored_bushels
    yield_per_acre = 3.
    land_acres = harvest / yield_per_acre
    immigrants = 5.
    plague_resistance = 1.
    deaths = 0.

    while True:
        print 
        print "LAST YEAR", deaths, "PEOPLE STARVED,", 
        print immigrants, "CAME TO THE CITY"
        population = population + immigrants
        if plague_resistance <= 0:
            print "HALF DIED OF THE PLAGUE"
            population = roundInt(population/2.)
        print "POPULATION IS NOW", population
        print "CITY OWNS", land_acres, "ACRES,", 
        print yield_per_acre, "BUSHELS HARVESTED PER ACRE"
        print "RATS DESTROYED", loss_to_rats, "BUSHELS,", 
        print stored_bushels, "BUSHELS IN STORE"
        print
        while True:
            answer = raw_input("DO YOU WISH TO ABDICATE? (yes or no) ")
            if answer.upper() == "NO":
                break
            if answer.upper() == "YES":
                # abdicate means quit being king
                return
        land_price = (10 * random.random()) + 17
        print "LAND COSTS", land_price, "BUSHELS PER ACRE"
        while True:
            purchased_acres = inputNumber("BUY")
            if land_price * purchased_acres < stored_bushels:
                break
            error(land_acres, population, stored_bushels)
        if purchased_acres > 0.:
            land_acres = land_acres + purchased_acres
            stored_bushels = stored_bushels - land_price * purchased_acres
        else:
           while True:
               sold_acres = inputNumber("SELL")
               if sold_acres >= land_acres:
                   error(land_acres, population, stored_bushels)
                   continue
               break
           land_acres = land_acres - sold_acres
           stored_bushels = stored_bushels + land_price * sold_acres
        while True:
            food_consumption = inputNumber("BUSHELS FOR FOOD")
            if food_consumption > stored_bushels:
                error(land_acres, population, stored_bushels)
            else:
                break
        stored_bushels = stored_bushels - food_consumption
        while True:
            planted_acres = inputNumber("ACRES TO PLANT")
            if planted_acres > land_acres:
                error(land_acres, population, stored_bushels)
                continue
            if roundInt(planted_acres/2.) >= stored_bushels:
                error(land_acres, population, stored_bushels)
                continue
            if planted_acres >= 10 * population:
                error(land_acres, population, stored_bushels)
                continue
            break
        stored_bushels = stored_bushels - roundInt(planted_acres/2.)
        yield_per_acre = random1thru5()
        harvest = planted_acres * yield_per_acre
        loss_to_rats = 0.
        C = random1thru5()
        if roundInt(C/2) == C/2.:
            loss_to_rats = roundInt(stored_bushels/C)
        stored_bushels = stored_bushels - loss_to_rats + harvest
        C = random1thru5()
        immigrants=roundInt(C*(20*land_acres+stored_bushels)/population/100+1)
        people_fed = roundInt(food_consumption/20.)
        plague_resistance = roundInt(10*(2*random.random()-1))
        if population < people_fed:
            deaths = 0.
        else:
            deaths = population - people_fed
            population = people_fed


def error(land_acres, population, stored_bushels):
    print "THINK AGAIN, YOU HAVE",
    print land_acres, "ACRES,", population, "PEOPLE,", 
    print stored_bushels, "BUSHELS"


def roundInt(n):
    """Round to next lowest integer, but still keep it a floating point
    number."""
    return float(int(n))


def inputNumber(msg=""):
    number = None
    while number is None:
        answer = raw_input(msg + "? ")
        try:
            number = float(answer)
        except ValueError:
            number = None
    return number


def random1thru5():
    return roundInt(random.random() * 5.) + 1.


main()

# end-of-file
