# drag.py
# Sample program to show dragging an object with the mouse

from cpif.graphics import DrawingWindow

def objectClicked(mouse_event, data):
    dw, id = data
    points = {'x': mouse_event.x, 'y': mouse_event.y}
    dw.onMouseMoveCall(mouseMoved, (points, dw, id))
    dw.onMouseUpCall(moveDone, dw)

def mouseMoved(mouse_event, data):
    points, dw, id = data
    deltaX = mouse_event.x - points['x']
    deltaY = mouse_event.y - points['y']
    points['x'] = mouse_event.x
    points['y'] = mouse_event.y
    dw.moveBy(id, deltaX, deltaY)

def moveDone(mouse_event, dw):
    dw.onMouseMoveCall(None, None)
    dw.onMouseUpCall(None, None)

dw = DrawingWindow(350, 350)
dw.drawText(0, 0, "Click and drag the objects.", 'black')
circle = dw.circle(175, 175, 50, 'black', fill='blue')
box = dw.box(100, 100, 120, 140, 'black', fill='yellow')
dw.onClickCall(circle, objectClicked, (dw, circle))
dw.onClickCall(box, objectClicked, (dw, box))
dw.run()

# end-of-file
