# cpifsong.py
# Play a song using the cpif.music module.
"""
This script plays the "CPIF Theme Song",
by David Handy
"""

from cpif.music import soundOfMusic
from cpif.sound import mix, mul, play


righthand_notes = [
    # Measure 1
    ('C4', 0.25),
    # Measure 2
    ('G4', 0.25), ('C4', 0.25),
    ('G4', 0.125), ('F4', 0.125), ('E4', 0.125), ('D4', 0.125),
    # Measure 3
    ('F4', 0.25), ('E4', 0.25), ('D4', 0.5),
    # Measure 4
    ('G4', 0.25), ('C4', 0.25),
    ('G4', 0.125), ('F4', 0.125), ('E4', 0.125), ('D4', 0.125),
    # Measure 5
    ('E4', 0.25), ('D4', 0.25), ('C4', 0.5)
    ]

lefthand_notes = [
    # Measure 1
    ('', 0.25), # quarter rest
    # Measure 2
    ('C3', 0.25), ('G3', 0.25), ('C3', 0.25), ('G3', 0.25),
    # Measure 3
    ('C3', 0.25), ('G3', 0.25), ('F3', 0.25), ('G3', 0.25),
    # Measure 4
    ('C3', 0.25), ('G3', 0.25), ('C3', 0.25), ('G3', 0.25),
    # Measure 5
    ('G3', 0.25), ('F3', 0.25), ('E3', 0.5)
    ]


def createSong():
    left_hand = soundOfMusic(lefthand_notes)
    right_hand = soundOfMusic(righthand_notes)
    factor = 0.5
    return mix([mul(left_hand, factor), mul(right_hand, factor)])


def playSong():
    song = createSong()
    play(song).wait()


playSong()

# end-of-file
