# lander1.py
# David Handy  June 2004
"""
Classic Lunar-lander style game.

Use the arrow keys to fire the rockets, Esc to quite the game.
"""

from cpif.graphics import DrawingWindow


def keyCallback(event):
    if event.keysym == 'Escape':
        dw.close()


def drawShip(x, y):
    size = 20
    p1 = (x,          y - size)
    p2 = (x + size/2, y + size)
    p3 = (x,          y + size/2)
    p4 = (x - size/2, y + size)
    id = dw.polygon([p1, p2, p3, p4], 'black', fill='blue')
    return id


width, height = 640, 480
dw = DrawingWindow(width, height)
dw.onKeyDownCall(keyCallback)
ship = drawShip(width/2, height/2)
dw.run()

# end-of-file
